@php
$cart = session()->get('cart', []);
@endphp
<div class="card border-0 h-100">
  <div class="card-header">
    <h5 class="mb-0">Shopping Cart</h5>
    <div class="btn cart_dismiss">
      <i class="fa fa-times"></i>
      Close
    </div>
  </div>
  <div class="card-body p-0">
    @php
        $total=0;
    @endphp
    @if(count($cart))
    @foreach($cart as $key=>$i)
    
    @php
    $total +=$i['price']*$i['quantity'];
    @endphp
                
    <div class="product">
        <div class="image p-2">
            <a href="{{ route('products.show',[$key])}}" class="">
              <img src=" {{ getImage('images/product/large', $i['image'])}} " alt="">
            </a>
        </div>
        <div class="content p-2">
          <p class="mb-1"><a href="" class="text-dark"> {{ $i['name']}} </a></p>
          <small>{{ $i['quantity'] }} x <span class="text-warning"> {{ $i['price'] }} </span></small>
        </div>
        <div class="product_dismiss p-2 ms-auto">
            <form method="POST" action="{{ route('carts.destroy',[$key])}}">
                @csrf
                @method('DELETE')
                <button class="close-btn" type="submit"><small class="fa fa-times"></small></button> 
            </form>
                    
          
        </div>
    </div>
    @endforeach
    @endif
    <div class="subtotal p-2 border-top position-absolute bottom-0 w-100">
      <div class="d-flex justify-content-between align-items-center">
        <h5>Subtotal:</h5>
        <h5 class="text-warning">{{ $total }}</h5>
      </div>
      <a href="" class="btn text-cap bg-muted d-block mb-2">View Cart</a>
      <a href="{{ route('checkouts.index')}}" class="btn text-cap btn-dark d-block">Checkout</a>
    </div>
    @if(count($cart)==0)
    <div class="text-center">
      <!-- for empty cart  -->
      <div class="empty_icon">
        <i class="fa fa-cart-arrow-down"></i>
      </div>
      <p>
        No products in the cart.
      </p>
      <a href="{{ route('shop')}}" class="btn btn-dark text-cap">Return To Shop</a>
    </div>
    @endif
  </div>
</div>