@extends('app')
@section('content')

<div class="container-xl">
    <div class="row">
      <div class="col-lg-4 " style="width: 290px;"></div>
      <div class="col-lg-8 flex-grow-1">
        <div id="main_carousel" class="carousel slide ps-lg-3 pt-3" data-bs-ride="carousel">
            <ol class="carousel-indicators">
                @foreach($sliders as $key=>$sld)
                <li data-bs-target="#main_carousel" data-bs-slide-to="{{$key}}" class="{{$key==0?'active':''}}" aria-current="true" aria-label="{{ $sld->title }}" ></li>
                @endforeach
            </ol>
          <div class="carousel-inner" role="listbox">
            
            @foreach($sliders as $key=>$sl)
            <div class="carousel-item {{$key==0?'active':''}}" data-bs-interval="2000">
              <a href="">
                <img
                src="{{ getImage('sliders',$sl->image) }}"
                class="w-100 d-block"
                alt="{{ $sl->title }}"
              />
              </a>
            </div>
            @endforeach
          </div>
        </div>
        
      </div>
    </div>
    <div class="products_types mt-3">
      <!-- Nav tabs -->
      <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
          <button
            class="nav-link active text-cap font-20 nato light"
            id="new-tab"
            data-bs-toggle="tab"
            data-bs-target="#new"
            type="button"
            role="tab"
            aria-controls="new"
            aria-selected="true"
          >
            New
          </button>
        </li>
        <li class="nav-item" role="presentation">
          <button
            class="nav-link text-cap font-20 nato light"
            id="top-tab"
            data-bs-toggle="tab"
            data-bs-target="#top"
            type="button"
            role="tab"
            aria-controls="top"
            aria-selected="false"
          >
            Top
          </button>
        </li>
        <li class="nav-item" role="presentation">
          <button
            class="nav-link text-cap font-20 nato light"
            id="flash-tab"
            data-bs-toggle="tab"
            data-bs-target="#flash"
            type="button"
            role="tab"
            aria-controls="flash"
            aria-selected="false"
          >
            <i class="fa fa-fire"></i>
            Flash Sale
          </button>
        </li>
      </ul>
      
      <!-- Tab panes -->
      <div class="tab-content">
        <div class="tab-pane active" id="new" role="tabpanel" aria-labelledby="new-tab">
          <div class="products mt-3">
            @foreach($products as $product)
            @if($product->is_new)
            @include('partials.product',['product'=>$product])
            @endif
            @endforeach
          </div>
        </div>
        <div class="tab-pane" id="top" role="tabpanel" aria-labelledby="top-tab">
          <div class="products mt-3">
                @foreach($products as $product)
                @if($product->is_top)
                @include('partials.product',['product'=>$product])
                @endif
                @endforeach
            
           </div>
        </div>
        <div class="tab-pane" id="flash" role="tabpanel" aria-labelledby="flash-tab">
          <div class="products mt-3">
                @foreach($products as $product)
                @if($product->is_flash)
                @include('partials.product',['product'=>$product])
                @endif
                @endforeach
            
           </div>
        </div>
      </div> 
      
    </div>
    
    @foreach($categories as $category)
    @if($category->products->count())
    <div class="category_products">
      <div class="banner rounded-2 {{$category->class_name}}">
        <div class="left ps-lg-5 ps-3">
          <div class="sub_title cavet"> {{ $category->tag}}</div>
          <div class="title">{{ $category->name}}</div>
        </div>
        <div class="right d-flex flex-wrap align-items-center pe-lg-5 pe-3 gap-2">
          <p class="mb-0"> {{ $category->note}} </p>
          <a href="{{ route('shop',['cat_id'=>$category->id])}}" class="btn px-5 rounded-5 text-cap btn-light opacity-75 medium ms-lg-3 ms-2">See All</a>
        </div>
      </div>
      <div class="products mt-3">
            @foreach($category->products as $product)
            @include('partials.product')
            @endforeach
       </div>
    </div>
    @endif
    @endforeach


  </div>
@endsection